% OFFLINE ANALYSIS

close all
clear all
clc


load('NET.mat')

% Prendo 4.1 s di osservazione di qualche soggetto non visto durante
% l'allenamento

location = uigetdir;
fds = fileDatastore(location,"FileExtensions",'.mat','ReadFcn',@load,'IncludeSubfolders',true);


% Subject must be added to the list

pat = "S" + digitsPattern(3);                % Pattern to be find
list_subject = extract(fds.Files,pat);

% Remove duplicate
list_subject = unique(list_subject);

[SUBidx,tf] = listdlg('ListString',list_subject,'SelectionMode','multiple','InitialValue',1);
SUBJECT_name = list_subject(SUBidx);

% Initialize MI-EEG

LF = {};
RF = {};

%% Loading subject specific MI-EEG

for i = 1:numel(SUBJECT_name)

    dir = [location filesep SUBJECT_name{i} filesep];

    oldFolder = cd(dir);

    LF_temp = load('LF');
    RF_temp = load('RF');


    LF = vertcat(LF,LF_temp.LF);
    RF = vertcat(RF,RF_temp.RF);


    cd(oldFolder);

end
XTest = vertcat(LF,RF);

% LF and RF label creation
LF_Label = repmat({'LF'},size(LF));
RF_Label = repmat({'RF'},size(RF));

LF_Label = categorical(LF_Label);
RF_Label = categorical(RF_Label);

YTest = vertcat(LF_Label,RF_Label);

%% Confusion matrix of the classification

tic

YPred = classify(net,XTest);

time = toc;

[con,order] = confusionmat(YTest,YPred);

CNN_RNNacc = sum(YPred == YTest)./numel(YTest)*100


figure
confusionchart(con,order)